<?php
namespace Persian_Flatsome;

    $active_data = Activator::decoder();
    $is_active = Activator::is_active();
?>
    <div class="wrap <?php echo Activator::$name ?> <?php echo $is_active ? 'active' : 'inactive' ?>">
        <div class="guard_activation_wrapper">

            <header>
                <img src="<?php echo $this->url ?>/assets/images/guard.png" alt="">
                <h2><?php _e('Activating product', $this->text_domain); ?></h2>
                <p>
                    <strong><?php _e('Product name:', $this->text_domain); ?></strong>
			        <?php printf(__('%s version %s', $this->text_domain), $this->title, self::$version) ?>
                </p>
                <div class="badge <?php echo $is_active ? 'active' : 'inactive' ?>">
                    <?php echo $is_active ? __('Status: Active', $this->text_domain) : __('Status: Inactive', $this->text_domain) ?>
                </div>
            </header>

            <section>
                <p>
		            <?php
		            printf( __( 'Dear user, thanks for using our product %s.', $this->text_domain ), $this->title );
		            ?>
                </p>
	            <?php
	            if ( $is_active ) {
		            $message = __( 'You product is active.', $this->text_domain );
		            $status  = 'active';
		            include $this->path . '/view/menu-content-status.php';
	            } else {
		            if ( $active_data ) {
			            $check_status = Activator::check_status( $active_data->license );
			            $message      = __( Activator::get_error_message( $check_status->code ), $this->text_domain );
			            $status       = 'inactive';
			            if( $check_status->code == -1 ) {
				            include $this->path . '/view/menu-content-form.php';
			            } else {
				            include $this->path . '/view/menu-content-status.php';
			            }
		            } else {
			            include $this->path . '/view/menu-content-form.php';
		            }
	            }
	            ?>
            </section>

        </div>

        <style>
            .wrap.<?php echo Activator::$name ?> {
                /*background: #4A148C;*/
            }

            .wrap.<?php echo Activator::$name ?> .activation .spinner {
                background-position: right center;
                padding-right: 30px;
                margin: 0;
                float: none;
                margin-top: 15px;
                width: 100%;
                visibility: visible;
                display: none;
                padding-top: 15px;
                font-size: 13px;
                line-height: 8px;
            }

            .wrap.<?php echo Activator::$name ?> .activation.waiting .spinner {
                display: inline-block;
            }
        </style>
    </div>