<?php
namespace Persian_Flatsome;

use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Parser;
use Lcobucci\JWT\Signer\Hmac\Sha256;
use Lcobucci\JWT\ValidationData;

class Activator {

	/**
	 * The single instance of the class.
	 *
	 * @var Activator
	 */
	protected static $_instance = null;

//    public static $base_url = 'http://localhost/ProductsController/api';
	public static $base_url = 'https://update.mojtaba.dev/api';
	public static $terms_url = 'https://mojtaba.dev/terms/';
	public static $name;
	private static $version;
	private $title;
	private $path;
	private $url;
	private $parent_slug;
	private $text_domain = 'flatsome-activator';
	private $page_title;
	private $menu_title;
	private $is_licensed = false;
	private $transient;
	private static $option_name;
	private $max_network_error_days = 6;

	/**
	 * WP_Products_Controller constructor.
	 */
	private function __construct($product_name, $product_title, $version, $parent_slug, $is_licensed) {
		self::$name         = $product_name;
		$this->title        = $product_title;
		self::$version      = $version;
		$this->path         = plugin_dir_path( __FILE__ );
		$this->url          = plugin_dir_url( __FILE__ );
		$this->parent_slug  = $parent_slug;
		$this->is_licensed  = $is_licensed;
		$this->transient = sprintf('%s_%s', base64_encode($product_name), base64_encode(self::$base_url));
		self::$option_name  = sprintf('%s_%s_%s', base64_encode($product_name), base64_encode(site_url()), base64_encode(self::$name));


		add_action( 'plugins_loaded', array( $this, 'localization' ) );
		add_action('admin_menu', array($this, 'admin_menu'), 99);
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action(sprintf('wp_ajax_guard_%s_activator', str_replace('-', '_', self::$name)), array($this, 'activate'));
		add_action(sprintf('wp_ajax_guard_%s_checker', str_replace('-', '_', self::$name)), array($this, 'checker'));
		add_action(sprintf('wp_ajax_guard_%s_deactivator', str_replace('-', '_', self::$name)), array($this, 'deactivate'));
		add_action( 'admin_notices', array( $this, 'show_remote_messages' ), 15 );
		add_action( 'admin_notices', array( $this, 'show_activation_messages' ), 15 );
		add_action( 'admin_notices', array( $this, 'show_network_connection_messages' ), 15 );
		require_once( $this->path . 'libraries/jwt/vendor/autoload.php' );
		require_once( $this->path . 'libraries/Promotion.php' );
		Promotion::instance($parent_slug, $this->text_domain, $this->path);
	}

	/**
	 * Main Instance.
	 *
	 * Ensures only one instance of WP_Products_Controller is loaded or can be loaded.
	 *
	 * @static
	 * @return Activator - Main instance.
	 */
	public static function instance($product_name, $product_title, $version, $parent_slug, $is_licensed = false) {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self($product_name, $product_title, $version, $parent_slug, $is_licensed);
		}

		return self::$_instance;
	}

	/**
	 * Make plugin translatable
	 */
	public function localization() {
		$plugin_rel_path = plugin_basename( $this->path ) . '/languages';
		load_plugin_textdomain( $this->text_domain, false, $plugin_rel_path );
		$this->page_title = sprintf(__('Activate %s', $this->text_domain), $this->title);
		$this->menu_title = __('Activate', $this->text_domain);
		$this->title =__('Flatsome WooCommerce Theme', $this->text_domain);
	}

	public function enqueue_scripts( $hook ) {
		$current_page = str_replace('page_', '', strstr($hook, 'page_'));
		if( $current_page === sprintf('activate-%s', self::$name) || $current_page === sprintf('%s-promotion', $this->parent_slug) ) {
			wp_enqueue_style( sprintf('guard-%s-style', self::$name), $this->url . 'assets/css/guard.css', array(), '1.0.0', $media = 'all' );
			wp_enqueue_script( sprintf('guard-%s-js', self::$name), $this->url . 'assets/js/guard.js', array( 'jquery' ), '1.0.0', true );
			/*wp_localize_script(sprintf('guard-%s-js', self::$name), sprintf('guard-%s', self::$name), array(
				'name' => self::$name
			));*/
		}

	}

	/**
	 * Add submenu page for display registration form
	 */
	public function admin_menu() {
		add_submenu_page(
			$this->parent_slug,
			$this->page_title,
			$this->menu_title,
			'manage_options',
			sprintf('activate-%s', self::$name),
			array($this, 'menu_content')
		);
	}

	public function menu_content() {
		include $this->path.'view/menu-content.php';
	}

	public function set_page_title() {

	}

	public function set_menu_title() {

	}

	public function set_base_url( $base_url ) {

	}

	public function activate() {
		$license = ( isset($_POST['license']) && !empty($_POST['license']) ) ? sanitize_text_field($_POST['license']) : '';
		if( $this->is_licensed && !$license ) {
			wp_send_json_error(__('Please enter license code', $this->text_domain));
		}

		$body = array(
			'domain' => get_bloginfo('url'),
			'email' => get_bloginfo('admin_email'),
			'product' => self::$name,
			'version' => self::$version,
			'license' => $license,
		);

		$response = wp_remote_post( self::$base_url . '/token', array( 'body' => wp_json_encode( $body ) ) );
		if ( is_wp_error( $response ) ) {
			$error_message = $response->get_error_message();
			wp_send_json_error($error_message);
		} else {
			$body = json_decode(wp_remote_retrieve_body($response));
			if( $body->success ) {
				$token = $body->data;
				$activate_response = wp_remote_post( self::$base_url . '/activate', array(
					'body' => json_encode(array(
						'token' => $token,
					)),
				) );
				if ( is_wp_error( $activate_response ) ) {
					$error_message = $activate_response->get_error_message();
					wp_send_json_error($error_message);
				} else {
					$activate_body = json_decode(wp_remote_retrieve_body($activate_response));
					if( $activate_body->success ) {
						$set = self::set_info($license);
						if( $set ) {
							wp_send_json_success(__('Product activated successfully', $this->text_domain));
						}

						wp_send_json_error(__('Setting activation info failed. please try again.', $this->text_domain));
					}

					wp_send_json_error(__('Product activation failed! please try again.', $this->text_domain));
				}

			}

			wp_send_json_error($body->data);
		}
	}

	public function activate_curl() {
		$license = ( isset( $_POST['license'] ) && ! empty( $_POST['license'] ) ) ? sanitize_text_field( $_POST['license'] ) : '';
		if ( $this->is_licensed && ! $license ) {
			wp_send_json_error( __( 'Please enter license code', $this->text_domain ) );
		}

		$body = array(
			'domain'  => get_bloginfo( 'url' ),
			'email'   => get_bloginfo( 'admin_email' ),
			'product' => self::$name,
			'version' => self::$version,
			'license' => $license,
		);


		$curl = curl_init();
		curl_setopt_array( $curl, array(
			CURLOPT_URL            => self::$base_url . '/token',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING       => "",
			CURLOPT_MAXREDIRS      => 10,
			CURLOPT_TIMEOUT        => 30,
			CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST  => "POST",
			CURLOPT_POSTFIELDS     => wp_json_encode( $body ),
			CURLOPT_HTTPHEADER     => array(
				"content-type: application/json"
			),
		) );
		$response = curl_exec( $curl );
		$err      = curl_error( $curl );

		curl_close( $curl );

		if ( $err ) {
			wp_send_json_error( $err );
		} else {
			$body = json_decode( $response );
			if ( $body->success ) {
				$token             = $body->data;

				$curl = curl_init();

				curl_setopt_array($curl, array(
					CURLOPT_URL => self::$base_url . '/activate',
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING => "",
					CURLOPT_MAXREDIRS => 10,
					CURLOPT_TIMEOUT => 30,
					CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST => "POST",
					CURLOPT_POSTFIELDS => json_encode( array(
						'token' => $token,
					) ),
					CURLOPT_HTTPHEADER => array(
						"content-type: application/json"
					),
				));

				$response = curl_exec($curl);
				$err = curl_error($curl);

				curl_close($curl);

				if ($err) {
					wp_send_json_error( $err );
				} else {
					$activate_body = json_decode(  $response  );
					if ( $activate_body->success ) {
						$set = self::set_info( $license );
						if ( $set ) {
							wp_send_json_success( __( 'Product activated successfully', $this->text_domain ) );
						}

						wp_send_json_error( __( 'Setting activation info failed. please try again.',
							$this->text_domain ) );
					}

					wp_send_json_error( __( 'Product activation failed! please try again.', $this->text_domain ) );
				}


			}

			wp_send_json_error( $body->data );
		}

	}

	public function checker() {
		$active_data = self::decoder();
		$check_status = self::check_status($active_data->license);
		if( $check_status->success ) {
			self::set_info($active_data->license);
			wp_send_json_success(__('Your product is active.', $this->text_domain));
		}

		$message      = __( self::get_error_message( $check_status->code ), $this->text_domain );
//		$message      = __( $check_status->data );
		wp_send_json_error($message);
	}

	public function deactivate() {
		$active_data = self::decoder();
		$body = array(
			'domain'  => get_bloginfo( 'url' ),
			'product' => self::$name,
			'license' => isset($active_data->license) && !empty($active_data->license) ? $active_data->license : '',
		);

		$response = wp_remote_post( self::$base_url . '/deactivate', array( 'body' => wp_json_encode( $body ) ) );
		if ( is_wp_error( $response ) ) {
			$error_message = $response->get_error_message();
			wp_send_json_error($error_message);
		} else {
			$body = json_decode( wp_remote_retrieve_body( $response ), true );
			if( $body['success'] == false ) {
				wp_send_json_error($body['data']);
			}
		}

		$delete = delete_option(self::$option_name);
		if( $delete ) {
			wp_send_json_success(__('Product deactivated successfully', $this->text_domain));
		}

		wp_send_json_error(__('Deactivation failed! please try again.', $this->text_domain));
	}

	private static function encoder(  $domain, $email, $product_name, $license, $status ) {
		$signer = new Sha256();
		$jti = wp_generate_uuid4();
		$key = base64_encode( sprintf( '%s%s%s%s', $jti, $domain, $email, $product_name ) );
		$time = time();
		$token = ( new Builder() )->setIssuer( get_bloginfo( 'url' ) )// Configures the issuer (iss claim)
		                          ->setAudience( $domain )// Configures the audience (aud claim)
		                          ->setId( $jti, true )// Configures the id (jti claim), replicating as a header item
		                          ->setIssuedAt( $time )// Configures the time that the token was issued (iat claim)
		                          ->setExpiration( $time + 5 )// Configures the expiration time of the token (exp claim)
		                          ->set( 'domain', $domain )
		                          ->set( 'email', $email )
		                          ->set( 'product_slug', $product_name )
		                          ->set( 'license', $license )
		                          ->set( 'status', $status )
		                          ->sign( $signer, $key )
		                          ->getToken(); // Retrieves the generated token
		return (string) $token;
	}

	public static function decoder() {
		$token = get_option(self::$option_name);
		try  {
			$token = ( new Parser() )->parse( (string) $token ); // Parses from a string
			$data  = new ValidationData(); // It will use the current time to validate (iat, nbf and exp)

			$is_token_valid      = $token->validate( $data );
			$is_domain_valid     = get_bloginfo('url') == $token->getClaim( 'domain' );

			$data = new \stdClass();
			$data->domain = $token->getClaim( 'domain' );
			$data->email = $token->getClaim( 'email' );
			$data->product_slug = $token->getClaim( 'product_slug' );
			$data->license = $token->getClaim( 'license' );
			return $data;
		} catch (\InvalidArgumentException $exception) {
			return false;
		}
	}

	public final static function is_active() {
		$token = get_option(self::$option_name);
		try  {
			$token = ( new Parser() )->parse( (string) $token ); // Parses from a string
			$data  = new ValidationData(); // It will use the current time to validate (iat, nbf and exp)

			$is_token_valid      = $token->validate( $data );
			if( !$is_token_valid ) {
				$check_customer = self::check_status($token->getClaim( 'license' ));
				if( $check_customer->code == -4 || $check_customer->code === 0 ) {
					$is_token_valid = true;
				} else {
					$is_token_valid = $check_customer->success;
				}
				if( $check_customer->success ) {
					self::set_info($token->getClaim( 'license' ));
				}
			}
			$is_domain_valid     = get_bloginfo('url') == $token->getClaim( 'domain' );

			return $is_token_valid && $is_domain_valid;

		} catch (\InvalidArgumentException $exception) {
			return false;
		}
	}

	private static function set_info( $license = '', $status = 'active' ) {
		$token = self::encoder(get_bloginfo('url'), get_bloginfo('admin_email'), self::$name, $license, $status);
		update_option(self::$option_name, $token);

		return $token;
	}

	public static function check_status( $license = '' ) {
	    // $domain = preg_replace('/\?.*/', '', get_bloginfo( 'url' ));
	    $domain =  rtrim(strtok(get_bloginfo( 'url' ), '?'),"/");
		$body = array(
			'domain'  => $domain,
			'email'   => get_bloginfo( 'admin_email' ),
			'product' => self::$name,
			'license' => $license,
			'version' => self::$version,
		);

		$response = wp_remote_post( self::$base_url . '/check', array( 'body' => wp_json_encode( $body ) ) );
		$result = new \stdClass();

		if ( is_wp_error( $response ) ) {
			$error_message = $response->get_error_message();
			$result->success = false;
			$result->data = $error_message;
			$result->code = 0;
			$check_404 = get_option('fls_check_404', []);
			if( !in_array(strtotime('today'), $check_404) ) {
				$check_404[] = strtotime('today');
			}
			update_option('fls_check_404', $check_404);
		} else {
			if( wp_remote_retrieve_response_code($response) == 200 ) {
				$body = json_decode( wp_remote_retrieve_body( $response ), true );
				update_option('fls_check_404', []);
				$result->success = $body['success'];
				$result->data = $body['data'];
				$result->code = $body['code'];
			} else {
				$result->success = false;
				$result->data = self::get_error_message(-4);
				$result->code = -4;
				$check_404 = get_option('fls_check_404', []);
				if( !in_array(strtotime('today'), $check_404) ) {
					$check_404[] = strtotime('today');
				}
				update_option('fls_check_404', $check_404);
			}
		}
		return $result;
	}

	public static function get_error_message( $error_code ) {
		switch ($error_code) {
			case -4:
				return __('There is a connection problem with our servers. But your theme is still activated');
				break;
			case -3:
				return __('Your license code is not valid.');
				break;
			case -2:
				return __('Your product status is not active in our database, please contact us for mo info.');
				break;
			case -1:
				return __('There is no customer with this info in our db, please contact us for mo info.');
				break;
			case 0:
				return __('There is a connection problem with our servers. please try again.');
				break;
			case 1:
				return __('Your product is active.');
				break;
			default:
				return __('Unknown error');
		}
	}

	public function show_remote_messages() {
		$promotions = get_transient( $this->transient );
		if ( $promotions === false ) {
			$response = wp_remote_get( sprintf('%s/output', self::$base_url) );
			if ( ! is_wp_error( $response ) ) {
				$body       = wp_remote_retrieve_body( $response );
				$promotions = json_decode( $body, true );
				set_transient( $this->transient, $promotions, 86400 );
			}
		}

		$show_promotions = [];
		$update_messages = [];

		// Get general promotions
		if ( isset( $promotions['general'] ) && ! empty( $promotions['general'] ) ) {
			foreach ( $promotions['general'] as $promotion ) {
				$show_promotions[] = $promotion;
			}
		}

		// Get specific product promotions
		if ( isset( $promotions['products'] ) && ! empty( $promotions['products'] ) ) {
			foreach ( $promotions['products'] as $product_promotion ) {
				if ( $product_promotion['product'] === self::$name ) {
					$show_promotions[] = $product_promotion;
				}
			}
		}

		// Get update messages
		if ( isset( $promotions['update'] ) && ! empty( $promotions['update'] ) ) {
			if ( array_key_exists( self::$name, $promotions['update'] ) ) {
				if ( version_compare( self::$version, $promotions['update'][ self::$name ]['version'], '<' ) ) {
					$update_messages[] = $promotions['update'][ self::$name ];
				}
			}
		}

		if ( ! empty( $show_promotions ) ) {
			foreach ( $show_promotions as $show_promotion ) {
				$class           = self::$name . '_promotions notice notice-' . $show_promotion['type'];
				$unique_promo_id = self::$name . '-notice-' . md5( $show_promotion['id'] );
				if ( isset( $_COOKIE[ $unique_promo_id ] ) && ! empty( $_COOKIE[ $unique_promo_id ] ) && $_COOKIE[ $unique_promo_id ] === 'hide' ) {
					continue;
				}
				if ( isset( $show_promotion['expire'] ) && ! empty( $show_promotion['expire'] ) && time() > strtotime( $show_promotion['expire'] ) ) {
					continue;
				}
				if ( isset( $show_promotion['start'] ) && ! empty( $show_promotion['start'] ) && time() < strtotime( $show_promotion['start'] ) ) {
					continue;
				}
				?>
                <div class="<?php echo $class ?>" style="position: relative;">
					<?php if ( isset( $show_promotion['image'] ) && ! empty( $show_promotion['image'] ) ): ?>
                        <img src="<?php echo $show_promotion['image']; ?>" alt=""
                             style="float: right;  height: auto; margin: 10px 0 10px 20px;">
					<?php endif; ?>
                    <h3><?php echo $show_promotion['title'] ?></h3>
                    <p>
						<?php echo $show_promotion['description'] ?>
                        <button type="button" class="notice-dismiss" data-id="<?php echo $unique_promo_id ?>">
                            <span class="screen-reader-text">Dismiss this notice.</span>
                        </button>
                    </p>
                    <p class="submit">
                        <a href="<?php echo esc_url( $show_promotion['button_url'] ); ?>" class="button-primary"
                           target="_blank">
							<?php echo $show_promotion['button_text']; ?>
                        </a>
                    </p>
					<?php if ( isset( $show_promotion['image'] ) && ! empty( $show_promotion['image'] ) ): ?>
                        <div style="clear: both;"></div>
					<?php endif; ?>

                </div>
				<?php
			}
			?>
            <script>
              (function ($) {
                $(document).on('click', '.<?php echo self::$name; ?>_promotions .notice-dismiss', function () {
                  var promoId = $(this).data('id');
                  document.cookie = promoId + "=hide;path=/";
                  $(this).parents('.<?php echo self::$name; ?>_promotions').hide(300);
                });
              })(jQuery);

            </script>
			<?php
		}

		if ( ! empty( $update_messages ) ) {
			foreach ( $update_messages as $update_message ) {
				?>
                <div class="update-nag">
					<?php echo $update_message['description'] ?>
                    <a href="<?php echo esc_url( $update_message['button_url'] ); ?>" class="button-secondary"
                       target="_blank">
						<?php echo $update_message['button_text']; ?>
                    </a>
                </div>
				<?php
			}
		}
	}

	public function show_activation_messages() {
		$class = 'notice notice-error';
		$message = sprintf(__( 'There is something wrong with your <strong>%s</strong> theme. please check it', $this->text_domain ), $this->title);
		$is_active = self::is_active();
		if( !$is_active ) {
			printf(
				'<div class="%1$s"><p>%2$s <a href="%3$s" class="button-primary">%4$s</a></p></div>',
				esc_attr( $class ),
				$message,
				admin_url('admin.php?page='.sprintf('activate-%s', self::$name)),
				__('Check status', $this->text_domain)
			);
		}
	}

	public function show_network_connection_messages() {
		$check_404 = get_option('fls_check_404', []);
		if (count($check_404) > $this->max_network_error_days) {
			$class   = 'notice notice-error';
			$message = sprintf(__('There is a server connection error for multiple days with your <strong>%s</strong> theme. To prevent any problem please contact us',
				$this->text_domain), $this->title);
			printf('<div class="%1$s"><p>%2$s <a href="%3$s" target="_blank" class="button-primary">%4$s</a></p></div>',
				esc_attr($class), $message, 'https://www.zhaket.com/dashboard/tickets/new',
				__('Submit ticket', $this->text_domain));
		}
	}

}
