<?php
namespace Persian_Flatsome;

class Main {

	/**
	 * The single instance of the class.
	 *
	 * @var Main
	 */
	protected static $_instance = null;

	public static $version = '3.12.0';

	private $name;

	private $description;

	private $author;

	private $fonts;

	/**
	 * Main constructor.
	 */
	public function __construct() {
		$this->name         = __('Persian Flatsome', 'flatsome-admin');
		$this->description  = __('This plugin is written by mojtaba darvishi for translating flatsome admin pages to persian.', 'flatsome-admin');
		$this->author       = __('Mojtaba Darvishi', 'flatsome-admin');

		$this->includes();

		add_action( 'plugins_loaded', array($this, 'load_text_domain') );

		// Frontend assets
		add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));

		add_action('init', array($this, 'set_fonts'));

		// Add settings menu page
		add_action('admin_menu', array($this, 'admin_menu'), 99);
		add_action( 'admin_init', array($this, 'settings_init'));

		add_action( 'admin_notices', array( $this, 'incompatible_theme_version' ), 15 );

		$theme_version = wp_get_theme( get_template() );
		Activator::instance(
			'flatsome',
			__('Flatsome WooCommerce Theme', 'flatsome-admin'),
			$theme_version['Version'],
			'flatsome-panel',
			true
		);
	}

	private function includes() {
		include_once Bootstrap::$path . 'includes/activator/activator.php';
		require_once Bootstrap::$path . '/includes/override_functions.php';
	}

	public function set_fonts() {
		$this->fonts = array(
			'iransans' => __('Iran sans', 'flatsome-admin'),
			'iransans-farsi-numbers' => __('Iran sans (Persian number)', 'flatsome-admin'),
			'iransans-dn' => __('Iran sans Hand writing', 'flatsome-admin'),
			'iranyekan' => __('Iran Yekan', 'flatsome-admin'),
			'iranyekan-farsi-numbers' => __('Iran Yekan (Persian number)', 'flatsome-admin'),
			'iransharp' => __('Iran Sharp', 'flatsome-admin'),
			'vazir' => __('Vazir', 'flatsome-admin'),
			'sahel' => __('Sahel', 'flatsome-admin'),
			'shabnam' => __('Shabnam', 'flatsome-admin'),
			'samim' => __('Samim', 'flatsome-admin'),
			'gandom' => __('Gandom', 'flatsome-admin'),
			'tanha' => __('Tanha', 'flatsome-admin'),
			'parastoo' => __('Parastoo', 'flatsome-admin'),
			'dirooz' => __('Dirooz', 'flatsome-admin'),
			'anjoman' => __('Anjoman', 'flatsome-admin'),
			'dana' => __('Dana', 'flatsome-admin'),
			'dana-fa' => __('Dana Fa Numbers', 'flatsome-admin'),
		);
	}


	/**
	 * Load plugin textdomain.
	 *
	 * @since 1.0.0
	 */
	public function load_text_domain() {
		$plugin_rel_path = plugin_basename( Bootstrap::$path ) . '/languages';
		load_plugin_textdomain( 'flatsome-admin', false, $plugin_rel_path );
		if( Activator::is_active() ) {
			load_plugin_textdomain( 'flatsome', false, $plugin_rel_path . '/theme' );
		}
	}

	public function enqueue_scripts() {
		$font = self::get_option('font', 'typography');
		if( isset($font) && !empty($font) && Activator::is_active() ) {
			wp_enqueue_style('flatsome-admin-'.$font.'font', Bootstrap::$url.'/assets/public/css/'.$font.'-font.css', array(), self::$version);
		}
	}


	public function admin_menu() {
		add_submenu_page(
			'flatsome-panel',
			__('Persian flatsome', 'flatsome-admin'),
			__('Persian flatsome', 'flatsome-admin'),
			'manage_options',
			'persian-flatsome',
			array($this, 'admin_menu_content')
		);
	}

	public function admin_menu_content() {
		?>
        <div class="wrap">
            <h1><?php _e('Persian settings', 'flatsome-admin') ?></h1>
			<?php $active_tab = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : 'general'; ?>
            <h2 class="nav-tab-wrapper" style="margin-bottom: 10px">
                <a href="<?php echo admin_url('admin.php?page=flatsome-persian-settings&tab=general') ?>" class="nav-tab <?php echo $active_tab == 'general' ? 'nav-tab-active' : ''; ?>"><?php _e('General', 'flatsome-admin') ?></a>
            </h2>

            <form method="post" action="options.php">
				<?php
				settings_errors();
				if( $active_tab == 'general' ) {
					settings_fields( 'flatsome-admin-group' );
					do_settings_sections( 'flatsome-admin-general-page' );
				} elseif( $active_tab == 'notifications' ) {
					settings_fields( 'flatsome-admin-group' );
					do_settings_sections( 'zhk_notifications_page' );
				}
				submit_button();
				?>
            </form>
        </div>
		<?php
	}

	public function settings_init() {
		register_setting(
			'flatsome-admin-group',
			'flatsome-admin-options'
		);

		// Settings Sections
		add_settings_section(
			'typography',
			__('Typography', 'flatsome-admin'),
			NULL,
			'flatsome-admin-general-page'
		);

		// Settings fields
		add_settings_field(
			'font',
			__('Font', 'flatsome-admin'),
			array($this, 'font_callback'),
			'flatsome-admin-general-page',
			'typography'
		);
	}

	public function font_callback() {
		?>
        <select name="flatsome-admin-options[typography][font]" id="font">
            <option value=""><?php _e('Theme default', 'flatsome-admin'); ?></option>
			<?php foreach ($this->fonts as $font_key => $font_title): ?>
                <option value="<?php echo $font_key ?>" <?php selected( self::get_option('font', 'typography'), $font_key ) ?>><?php echo $font_title ?></option>
			<?php endforeach; ?>
        </select>
		<?php
	}

	public static function get_option($option_name = false, $option_group = false)
	{
		$options = get_option('flatsome-admin-options');
		$sorted_options = array();


		$sorted_options['typography']['font'] = (isset($options['typography']['font']) && !empty($options['typography']['font'])) ? $options['typography']['font'] : '';

		if( !empty($option_name) && !empty($option_group) ) {
			return $sorted_options[$option_group][$option_name];
		} else {
			return $options;
		}
	}

	public function incompatible_theme_version() {
		$class = 'notice notice-error';
		$message = __( 'It seems your installed persian flatsome version is not compatible with your theme version', 'flatsome-admin' );
		$plugin_version = self::$version;
		$theme_version = wp_get_theme( get_template() );
		if( $theme_version['Version'] > $plugin_version && Activator::is_active() ) {
			printf(
				'<div class="%1$s"><p>%2$s <a href="%3$s" class="button-primary" target="_blank">%4$s</a></p></div>',
				esc_attr( $class ),
				$message,
				'https://flatsome.ir/category/changelog/',
				__('Update persian flatsome', 'flatsome-admin')
			);
		}

	}


	/**
	 * Main Class Instance.
	 *
	 * Ensures only one instance of this class is loaded or can be loaded.
	 *
	 * @static
	 * @return Main - Main instance.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
}