/**
 * External dependencies
 */
import { has } from 'lodash';

/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';

/**
 * Internal dependencies.
 */
import WrappedSection from './wrapped-section';

function SystemErrorDetails( { results } ) {
	return has( results, [ 'SYSTEM', 'ERROR' ] ) && (
		<WrappedSection type="system-error" status="error" description={ __( 'The scan failed to properly scan the site.', 'better-wp-security' ) }>
			<ul>
				{ results.SYSTEM.ERROR.map( ( entry, i ) => (
					<li className="itsec-malware-scan-error" key={ i }>
						<span>{ entry }</span>
					</li>
				) ) }
			</ul>
		</WrappedSection>
	);
}

export default SystemErrorDetails;
